/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.gdarp.pack_finders;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;

public class GlobalPackFinder
implements RepositorySource {
    private static final Predicate<Path> IS_VALID_RESOURCE_PACK = pack -> {
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("assets/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("assets/"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static final Predicate<Path> IS_VALID_DATA_PACK = pack -> {
        boolean flag = true;
        if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
            try (FileSystem fs = FileSystems.newFileSystem(pack);){
                flag &= Files.isDirectory(fs.getPath("data/", new String[0]), new LinkOption[0]);
                flag &= Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            flag &= Files.isDirectory(pack.resolve("data"), new LinkOption[0]);
            flag &= Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return flag;
    };
    private static PackSource GLOBAL = PackSource.m_247176_(name -> name.m_6881_().m_130946_(" (Global)").m_130940_(ChatFormatting.AQUA), (boolean)true);
    private static PackSource GLOBAL_OPT = PackSource.m_247176_(name -> name.m_6881_().m_130946_(" (Global Optional)").m_130940_(ChatFormatting.DARK_AQUA), (boolean)false);
    private final PackType packType;
    private final boolean forcedPacks;
    private final ImmutableList<Path> packLocations;

    public GlobalPackFinder(PackType packType, boolean required, List<Path> packLocations) {
        this.packType = packType;
        this.forcedPacks = required;
        this.packLocations = ImmutableList.builder().addAll(packLocations).build();
    }

    public void m_7686_(Consumer<Pack> packRegistrar) {
        this.discoverResourcePacks(path -> {
            Pack.ResourcesSupplier resourceSupplier = null;
            resourceSupplier = Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip") ? this.createFilePack((Path)path) : this.createFolderPack((Path)path);
            if (resourceSupplier == null) {
                return;
            }
            Pack pack = Pack.m_245429_((String)path.getFileName().toString(), (Component)Component.m_237113_((String)path.getFileName().toString()), (boolean)this.forcedPacks, (Pack.ResourcesSupplier)resourceSupplier, (PackType)this.packType, (Pack.Position)Pack.Position.TOP, (PackSource)(this.forcedPacks ? GLOBAL : GLOBAL_OPT));
            if (pack != null) {
                packRegistrar.accept(pack);
            }
        });
    }

    private Pack.ResourcesSupplier createFilePack(Path path) {
        Object supplier = null;
        FileSystem fs = path.getFileSystem();
        if (this.packType == PackType.CLIENT_RESOURCES && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == PackType.SERVER_DATA && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        if (fs == FileSystems.getDefault() || fs instanceof LinkFileSystem) {
            return needle -> new FilePackResources(needle, path.toFile(), false);
        }
        return null;
    }

    private Pack.ResourcesSupplier createFolderPack(Path path) {
        if (this.packType == PackType.CLIENT_RESOURCES && !IS_VALID_RESOURCE_PACK.test(path)) {
            return null;
        }
        if (this.packType == PackType.SERVER_DATA && !IS_VALID_DATA_PACK.test(path)) {
            return null;
        }
        return needle -> new PathPackResources(needle, path, false);
    }

    private void discoverResourcePacks(Consumer<Path> packCallback) {
        for (Path path : this.packLocations) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (Files.isRegularFile(path.resolve("pack.mcmeta"), new LinkOption[0])) {
                    packCallback.accept(path);
                    continue;
                }
                try {
                    if (Files.notExists(path, new LinkOption[0])) {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    Stream<Path> fileStream = Files.list(path);
                    try {
                        fileStream.forEach(filePath -> {
                            if (Files.isRegularFile(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0]) && Files.isRegularFile(filePath.resolve("pack.mcmeta"), new LinkOption[0])) {
                                packCallback.accept((Path)filePath);
                            }
                        });
                    }
                    finally {
                        if (fileStream == null) continue;
                        fileStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            packCallback.accept(path);
        }
    }
}

