/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.ItemOverrideProperty;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.CompoundKey;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemOverrideCache {
    private ItemOverrideProperty[] itemOverrideProperties;
    private Map<CompoundKey, Integer> mapModelIndexes = new HashMap();
    public static final Integer INDEX_NONE = new Integer(-1);

    public ItemOverrideCache(ItemOverrideProperty[] itemOverrideProperties) {
        this.itemOverrideProperties = itemOverrideProperties;
    }

    public Integer getModelIndex(cfz stack, few world, bfz entity) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return null;
        }
        return (Integer)this.mapModelIndexes.get(valueKey);
    }

    public void putModelIndex(cfz stack, few world, bfz entity, Integer index) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return;
        }
        this.mapModelIndexes.put(valueKey, index);
    }

    private CompoundKey getValueKey(cfz stack, few world, bfz entity) {
        Object[] indexes = new Integer[this.itemOverrideProperties.length];
        for (int i = 0; i < indexes.length; ++i) {
            Integer index = this.itemOverrideProperties[i].getValueIndex(stack, world, entity);
            if (index == null) {
                return null;
            }
            indexes[i] = index;
        }
        return new CompoundKey(indexes);
    }

    public static ItemOverrideCache make(List<fla> overrides) {
        if (overrides.isEmpty()) {
            return null;
        }
        if (!Reflector.ItemOverride_listResourceValues.exists()) {
            return null;
        }
        LinkedHashMap<acq, HashSet<Float>> propertyValues = new LinkedHashMap<acq, HashSet<Float>>();
        for (fla itemOverride : overrides) {
            List resourceValues = (List)Reflector.getFieldValue((Object)itemOverride, (ReflectorField)Reflector.ItemOverride_listResourceValues);
            for (fla.b resourceValue : resourceValues) {
                acq loc = resourceValue.a();
                float val = resourceValue.b();
                HashSet<Float> setValues = (HashSet<Float>)propertyValues.get(loc);
                if (setValues == null) {
                    setValues = new HashSet<Float>();
                    propertyValues.put(loc, setValues);
                }
                setValues.add(Float.valueOf(val));
            }
        }
        ArrayList<ItemOverrideProperty> listProps = new ArrayList<ItemOverrideProperty>();
        Set setPropertyLocations = propertyValues.keySet();
        for (acq loc : setPropertyLocations) {
            Set setValues = (Set)propertyValues.get(loc);
            float[] values = Floats.toArray((Collection)setValues);
            ItemOverrideProperty prop = new ItemOverrideProperty(loc, values);
            listProps.add(prop);
        }
        ItemOverrideProperty[] props = listProps.toArray(new ItemOverrideProperty[listProps.size()]);
        ItemOverrideCache cache = new ItemOverrideCache(props);
        ItemOverrideCache.logCache((ItemOverrideProperty[])props, overrides);
        return cache;
    }

    private static void logCache(ItemOverrideProperty[] props, List<fla> overrides) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < props.length; ++i) {
            ItemOverrideProperty prop = props[i];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(prop.getLocation() + "=" + prop.getValues().length);
        }
        if (overrides.size() > 0) {
            sb.append(" -> " + overrides.get(0).a() + " ...");
        }
        Config.dbg((String)("ItemOverrideCache: " + sb.toString()));
    }

    public String toString() {
        return "properties: " + this.itemOverrideProperties.length + ", modelIndexes: " + this.mapModelIndexes.size();
    }
}

